package GraphicThreads;

import javafx.application.Platform;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import UI.MyPane;
import Back.Node;


public class BalanceThread<T extends Serializable & Comparable<T> > extends GraphicThread {

    /**
     * konstruktor
     * @param _pane smernik na pane na ktorom bude pracovat
     */
    public BalanceThread( MyPane<T> _pane ) {
        pane = _pane;
        tree = pane.getTree1();
        SLEEP_TIME = 1000;
    }

    /**
     * vrati velkost podstromu pre vrchol + 1
     * vykresluje co uz zapocital
     * @param node vrchol ktoreho velkost chceme
     */
    private int threadSize( Node<T> node ) {
        node.setFind(true);
        updateTree();
        int count = 1;
        if (node.getSons() != null) {
            for (Node<T> son : node.getSons())
                if (son != null)
                    count += threadSize(son);
        }
        return count;
    }


    /**
     * prerobeny graficky balance
     * vypocita balance pre vrchol nasledovne
     * pre kazdeho syna zisti jeho velkost
     * od najvacsieho odcita rozdiel ktory zpriemeruje
     * @param node vrchol ktoreho balance chceme
     */
    public double threadBalance( Node<T> node ){
        node.setAdd(true);
        updateTree();
        if ( node.getSons() == null) return 0;
        if ( node.getSons().size() == 0 | node.getSons().size() == 1  ) return 0;

        ArrayList<Integer> list = new ArrayList<Integer>();

        for ( Node n : node.getSons() ){
            list.add(threadSize(n)-1);
        }

        //return ( list.isEmpty() )? 0 : Collections.max(list) - Collections.min(list);

        int m = Collections.max(list);
        double vys = 0;

        for ( int size : list ){
            vys += m - size;
        }

        return ( vys == 0 ) ? 0d :  Math.round( vys*100 / (list.size()-1) ) / 100  ;
    }

    /**
     * vypocita balance pre tree1
     * vysledok vypise a caka na uzivatela
     * pokial potvrdi ze si informaciu precital
     */
    @Override
    public void run() {
        double bal = threadBalance(tree.getRoot());

        if ( bal == 0 ) {
            Platform.runLater(() -> {
                pane.setOk("Ostatne.Tree is balanced");
            });
        } else {
            Platform.runLater(() -> {
                pane.setOk("Average deviation is " + bal);
            });
        }


    }
}
